/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.inventory.container.backpack;

import com.github.tartaricacid.touhoulittlemaid.entity.backpack.data.FurnaceBackpackData;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.MaidMainContainer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.FurnaceResultSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class FurnaceBackpackContainer
extends MaidMainContainer {
    public static final MenuType<FurnaceBackpackContainer> TYPE = IForgeMenuType.create((windowId, inv, data) -> new FurnaceBackpackContainer(windowId, inv, data.readInt()));
    private final ContainerData data;

    public FurnaceBackpackContainer(int id, Inventory inventory, int entityId) {
        super(TYPE, id, inventory, entityId);
        FurnaceBackpackData furnaceData = this.getMaid().getBackpackData() instanceof FurnaceBackpackData ? (FurnaceBackpackData)this.getMaid().getBackpackData() : new FurnaceBackpackData(this.getMaid());
        this.data = furnaceData.getDataAccess();
        this.m_38897_(new Slot((Container)furnaceData, 0, 161, 101){

            public boolean m_5857_(ItemStack stack) {
                return EntityMaid.canInsertItem(stack);
            }
        });
        this.m_38897_(new FurnaceBackpackFuelSlot(this, (Container)furnaceData, 1, 161, 142));
        this.m_38897_((Slot)new FurnaceResultSlot(inventory.f_35978_, (Container)furnaceData, 2, 221, 121));
        this.m_38884_(this.data);
    }

    @Override
    protected void addBackpackInv(Inventory inventory) {
        int i;
        ItemStackHandler itemHandler = this.maid.getMaidInv();
        for (i = 0; i < 6; ++i) {
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)itemHandler, 6 + i, 143 + 18 * i, 57));
        }
        for (i = 0; i < 6; ++i) {
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)itemHandler, 12 + i, 143 + 18 * i, 75));
        }
    }

    private boolean isFuel(ItemStack stack) {
        return ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_) > 0;
    }

    public int getBurnProgress() {
        int cookingProgress = this.data.m_6413_(2);
        int cookingTotalTime = this.data.m_6413_(3);
        return cookingTotalTime != 0 && cookingProgress != 0 ? cookingProgress * 24 / cookingTotalTime : 0;
    }

    public int getLitProgress() {
        int litDuration = this.data.m_6413_(1);
        if (litDuration == 0) {
            litDuration = 200;
        }
        return this.data.m_6413_(0) * 13 / litDuration;
    }

    public boolean isLit() {
        return this.data.m_6413_(0) > 0;
    }

    public static class FurnaceBackpackFuelSlot
    extends Slot {
        private final FurnaceBackpackContainer furnaceBackpackContainer;

        public FurnaceBackpackFuelSlot(FurnaceBackpackContainer furnaceBackpackContainer, Container container, int slot, int pX, int pY) {
            super(container, slot, pX, pY);
            this.furnaceBackpackContainer = furnaceBackpackContainer;
        }

        public boolean m_5857_(ItemStack stack) {
            return this.furnaceBackpackContainer.isFuel(stack) || FurnaceBackpackFuelSlot.isBucket(stack);
        }

        public int m_5866_(ItemStack stack) {
            return FurnaceBackpackFuelSlot.isBucket(stack) ? 1 : super.m_5866_(stack);
        }

        public static boolean isBucket(ItemStack stack) {
            return stack.m_150930_(Items.f_42446_);
        }
    }
}

