/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.inventory.container.other;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemWirelessIO;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class WirelessIOContainer
extends AbstractContainerMenu {
    public static final MenuType<WirelessIOContainer> TYPE = IForgeMenuType.create((windowId, inv, data) -> new WirelessIOContainer(windowId, inv, data.m_130267_()));
    private final ItemStack wirelessIO;
    private final ItemStackHandler filterListInv;

    public WirelessIOContainer(int id, Inventory inventory, ItemStack wirelessIO) {
        super(TYPE, id);
        this.wirelessIO = wirelessIO;
        this.filterListInv = ItemWirelessIO.getFilterList(wirelessIO);
        this.addPlayerSlots(inventory);
        this.addWirelessIOSlots();
    }

    public boolean m_6875_(Player playerIn) {
        return playerIn.m_21205_().m_41720_() == InitItems.WIRELESS_IO.get();
    }

    public void m_150399_(int slotId, int button, ClickType clickTypeIn, Player player) {
        if (slotId == 27 + player.m_150109_().f_35977_) {
            return;
        }
        if (clickTypeIn == ClickType.SWAP) {
            return;
        }
        super.m_150399_(slotId, button, clickTypeIn, player);
        ItemWirelessIO.setFilterList(this.wirelessIO, this.filterListInv);
    }

    private void addWirelessIOSlots() {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                this.m_38897_((Slot)new WirelessIOSlotItemHandler((IItemHandler)this.filterListInv, col + row * 3, 62 + col * 18, 17 + row * 18));
            }
        }
    }

    private void addPlayerSlots(Inventory inventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)inventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)inventory, col, 8 + col * 18, 142));
        }
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack stack1 = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack stack2 = slot.m_7993_();
            stack1 = stack2.m_41777_();
            if (index < 27 ? !this.m_38903_(stack2, 27, 36, true) : !this.m_38903_(stack2, 0, 27, false)) {
                return ItemStack.f_41583_;
            }
            if (stack2.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return stack1;
    }

    public ItemStack getWirelessIO() {
        return this.wirelessIO;
    }

    private class WirelessIOSlotItemHandler
    extends SlotItemHandler {
        private WirelessIOSlotItemHandler(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public int m_6641_() {
            return 1;
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return EntityMaid.canInsertItem(stack) && super.m_5857_(stack);
        }
    }
}

