/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.OpenMaidAIDataScreenMessage;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class GetMaidAIDataMessage {
    private final int entityId;

    public GetMaidAIDataMessage(int entityId) {
        this.entityId = entityId;
    }

    public static void encode(GetMaidAIDataMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.entityId);
    }

    public static GetMaidAIDataMessage decode(FriendlyByteBuf buf) {
        return new GetMaidAIDataMessage(buf.readInt());
    }

    public static void handle(GetMaidAIDataMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> GetMaidAIDataMessage.handle(message, context));
        }
        context.setPacketHandled(true);
    }

    private static void handle(GetMaidAIDataMessage message, NetworkEvent.Context context) {
        EntityMaid maid;
        ServerPlayer sender = context.getSender();
        if (sender == null) {
            return;
        }
        Entity entity = sender.f_19853_.m_6815_(message.entityId);
        if (entity instanceof EntityMaid && (maid = (EntityMaid)entity).m_21830_((LivingEntity)sender)) {
            NetworkHandler.sendToClientPlayer(new OpenMaidAIDataScreenMessage(message.entityId, maid.getAiChatManager()), (Player)sender);
        }
    }
}

