/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public record RefreshMaidBrainMessage(int entityId) {
    public static void encode(RefreshMaidBrainMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.entityId);
    }

    public static RefreshMaidBrainMessage decode(FriendlyByteBuf buf) {
        return new RefreshMaidBrainMessage(buf.readInt());
    }

    public static void handle(RefreshMaidBrainMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                EntityMaid maid;
                ServerPlayer sender = context.getSender();
                if (sender == null) {
                    return;
                }
                Entity entity = sender.f_19853_.m_6815_(message.entityId);
                if (entity instanceof EntityMaid && (maid = (EntityMaid)entity).m_21830_((LivingEntity)sender)) {
                    maid.refreshBrain((ServerLevel)sender.f_19853_);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

