/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class SendUserChatMessage {
    private final int maidId;
    private final String message;
    private final String language;

    public SendUserChatMessage(int maidId, String message, String language) {
        this.maidId = maidId;
        this.message = message;
        this.language = language;
    }

    public static void encode(SendUserChatMessage message, FriendlyByteBuf buf) {
        buf.m_130130_(message.maidId);
        buf.m_130070_(message.message);
        buf.m_130070_(message.language);
    }

    public static SendUserChatMessage decode(FriendlyByteBuf buf) {
        return new SendUserChatMessage(buf.m_130242_(), buf.m_130277_(), buf.m_130277_());
    }

    public static void handle(SendUserChatMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> SendUserChatMessage.onHandle(message, context));
        }
        context.setPacketHandled(true);
    }

    private static void onHandle(SendUserChatMessage message, NetworkEvent.Context context) {
        EntityMaid maid;
        ServerPlayer sender = context.getSender();
        if (sender == null) {
            return;
        }
        Entity entity = sender.f_19853_.m_6815_(message.maidId);
        if (entity instanceof EntityMaid && (maid = (EntityMaid)entity).m_21830_((LivingEntity)sender) && maid.m_6084_()) {
            maid.getAiChatManager().chat(message.message, message.language);
        }
    }
}

