/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.data.inner.AttackListData;
import com.github.tartaricacid.touhoulittlemaid.entity.misc.MonsterType;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTaskData;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class SetAttackListMessage {
    private final int entityId;
    private final Map<ResourceLocation, MonsterType> attackGroups;

    public SetAttackListMessage(int entityId, Map<ResourceLocation, MonsterType> attackGroups) {
        this.entityId = entityId;
        this.attackGroups = attackGroups;
    }

    public static void encode(SetAttackListMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.entityId);
        buf.m_130130_(message.attackGroups.size());
        for (ResourceLocation id : message.attackGroups.keySet()) {
            buf.m_130085_(id);
            buf.m_130068_((Enum)message.attackGroups.get(id));
        }
    }

    public static SetAttackListMessage decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        HashMap attackGroupsOutput = Maps.newHashMap();
        int size = buf.m_130242_();
        for (int i = 0; i < size; ++i) {
            ResourceLocation id = buf.m_130281_();
            MonsterType type = (MonsterType)buf.m_130066_(MonsterType.class);
            attackGroupsOutput.put(id, type);
        }
        return new SetAttackListMessage(entityId, attackGroupsOutput);
    }

    public static void handle(SetAttackListMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> SetAttackListMessage.writeList(message, context));
        }
        context.setPacketHandled(true);
    }

    private static void writeList(SetAttackListMessage message, NetworkEvent.Context context) {
        EntityMaid maid;
        ServerPlayer sender = context.getSender();
        if (sender == null) {
            return;
        }
        Entity entity = sender.f_19853_.m_6815_(message.entityId);
        if (entity instanceof EntityMaid && (maid = (EntityMaid)entity).m_21830_((LivingEntity)sender)) {
            maid.setAndSyncData(InitTaskData.ATTACK_LIST, new AttackListData(message.attackGroups));
        }
    }
}

