/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class SpawnParticleMessage {
    private final int entityId;
    private final Type particleType;
    private final int delayTicks;

    public SpawnParticleMessage(int entityId, Type particleType, int delayTicks) {
        this.entityId = entityId;
        this.particleType = particleType;
        this.delayTicks = delayTicks;
    }

    public SpawnParticleMessage(int entityId, Type particleType) {
        this(entityId, particleType, 0);
    }

    public static void encode(SpawnParticleMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.entityId);
        buf.writeInt(message.particleType.ordinal());
        buf.m_130130_(message.delayTicks);
    }

    public static SpawnParticleMessage decode(FriendlyByteBuf buf) {
        return new SpawnParticleMessage(buf.readInt(), SpawnParticleMessage.getTypeByIndex(buf.readInt()), buf.m_130242_());
    }

    public static void handle(SpawnParticleMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            if (message.delayTicks <= 0) {
                context.enqueueWork(() -> SpawnParticleMessage.handleSpawnParticle(message));
            } else {
                context.enqueueWork(() -> CompletableFuture.runAsync(() -> SpawnParticleMessage.handleSpawnParticleDelay(message, message.delayTicks), Util.m_183991_()));
            }
        }
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleSpawnParticleDelay(SpawnParticleMessage message, int delayTicks) {
        try {
            Thread.sleep((long)delayTicks * 50L);
            Minecraft.m_91087_().m_18689_(() -> SpawnParticleMessage.handleSpawnParticle(message));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleSpawnParticle(SpawnParticleMessage message) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        Entity e = mc.f_91073_.m_6815_(message.entityId);
        if (e instanceof EntityMaid && e.m_6084_()) {
            EntityMaid maid = (EntityMaid)e;
            switch (message.particleType) {
                case EXPLOSION: {
                    maid.spawnExplosionParticle();
                    return;
                }
                case BUBBLE: {
                    maid.spawnBubbleParticle();
                    return;
                }
                case HEART: {
                    maid.spawnHeartParticle();
                    return;
                }
                case RANK_UP: {
                    maid.spawnRankUpParticle();
                    return;
                }
                case HEAL: {
                    maid.spawnRestoreHealthParticle(maid.m_217043_().m_188503_(3) + 7);
                    return;
                }
            }
        }
    }

    private static Type getTypeByIndex(int index) {
        return Type.values()[Mth.m_14045_((int)index, (int)0, (int)(Type.values().length - 1))];
    }

    public static enum Type {
        EXPLOSION,
        BUBBLE,
        HEART,
        RANK_UP,
        HEAL;

    }
}

