/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public record YsmMaidModelMessage(int maidId, String modeId, String texture, Component name) {
    public static void encode(YsmMaidModelMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.maidId);
        buf.m_130070_(message.modeId);
        buf.m_130070_(message.texture);
        buf.m_130083_(message.name);
    }

    public static YsmMaidModelMessage decode(FriendlyByteBuf buf) {
        return new YsmMaidModelMessage(buf.readInt(), buf.m_130277_(), buf.m_130277_(), buf.m_130238_());
    }

    public static void handle(YsmMaidModelMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                EntityMaid maid;
                ServerPlayer sender = context.getSender();
                if (sender == null) {
                    return;
                }
                Entity entity = sender.f_19853_.m_6815_(message.maidId);
                if (entity instanceof EntityMaid && (maid = (EntityMaid)entity).m_21830_((LivingEntity)sender)) {
                    if (sender.m_7500_() || ((Boolean)MaidConfig.MAID_CHANGE_MODEL.get()).booleanValue()) {
                        maid.setIsYsmModel(true);
                        maid.setYsmModel(message.modeId, message.texture, message.name);
                        InitTrigger.MAID_EVENT.trigger(sender, "change_maid_model");
                    } else {
                        sender.m_213846_((Component)Component.m_237115_((String)"message.touhou_little_maid.change_model.disabled"));
                    }
                }
            });
        }
        context.setPacketHandled(true);
    }
}

