/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.tileentity;

import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class TileEntityPicnicMat
extends BlockEntity {
    public static final BlockEntityType<TileEntityPicnicMat> TYPE = BlockEntityType.Builder.m_155273_(TileEntityPicnicMat::new, (Block[])new Block[]{(Block)InitBlocks.PICNIC_MAT.get()}).m_58966_(null);
    private static final String CENTER_POS_NAME = "CenterPos";
    private static final String STORAGE_ITEM = "StorageItem";
    private static final String SIT_IDS = "SitIds";
    private final ItemStackHandler handler = new ItemStackHandler(9){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.m_41720_().m_41472_();
        }
    };
    private final UUID[] sitIds = new UUID[]{Util.f_137441_, Util.f_137441_, Util.f_137441_, Util.f_137441_};
    private BlockPos centerPos = BlockPos.f_121853_;

    public TileEntityPicnicMat(BlockPos pos, BlockState blockState) {
        super(TYPE, pos, blockState);
    }

    public void setCenterPos(BlockPos centerPos) {
        this.centerPos = centerPos;
        this.refresh();
    }

    public void setSitId(int index, UUID uuid) {
        if (index < 0 || index >= 4) {
            return;
        }
        this.sitIds[index] = uuid;
        this.refresh();
    }

    public UUID[] getSitIds() {
        return this.sitIds;
    }

    public BlockPos getCenterPos() {
        return this.centerPos;
    }

    public ItemStack getStorageItem(int slotId) {
        return this.handler.getStackInSlot(slotId);
    }

    public boolean isEmpty(int slotId) {
        return this.handler.getStackInSlot(slotId).m_41619_();
    }

    public void setHandler(ItemStackHandler stackHandler) {
        for (int i = 0; i < stackHandler.getSlots(); ++i) {
            ItemStack stack = stackHandler.getStackInSlot(i);
            if (i >= this.handler.getSlots()) {
                return;
            }
            this.handler.setStackInSlot(i, stack);
        }
        this.refresh();
    }

    public ItemStackHandler getHandler() {
        return this.handler;
    }

    protected void m_183515_(CompoundTag tag) {
        this.getPersistentData().m_128365_(CENTER_POS_NAME, (Tag)NbtUtils.m_129224_((BlockPos)this.centerPos));
        this.getPersistentData().m_128365_(STORAGE_ITEM, (Tag)this.handler.serializeNBT());
        ListTag listTag = new ListTag();
        for (UUID uuid : this.sitIds) {
            listTag.add((Object)NbtUtils.m_129226_((UUID)uuid));
        }
        this.getPersistentData().m_128365_(SIT_IDS, (Tag)listTag);
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.centerPos = NbtUtils.m_129239_((CompoundTag)this.getPersistentData().m_128469_(CENTER_POS_NAME));
        this.handler.deserializeNBT(this.getPersistentData().m_128469_(STORAGE_ITEM));
        ListTag sitIdsTag = this.getPersistentData().m_128437_(SIT_IDS, 11);
        int i = 0;
        for (Tag tag : sitIdsTag) {
            this.sitIds[i] = NbtUtils.m_129233_((Tag)tag);
            if (++i < 4) continue;
            break;
        }
    }

    public void refresh() {
        this.m_6596_();
        if (this.f_58857_ != null) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        }
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_.m_7918_(-3, 0, -3), this.f_58858_.m_7918_(3, 1, 3));
    }
}

