/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;

public final class ByteBufUtils {
    public static void writeStringSet(Set<String> set, FriendlyByteBuf buf) {
        buf.m_130130_(set.size());
        for (String s : set) {
            buf.m_130070_(s);
        }
    }

    public static Set<String> readStringSet(FriendlyByteBuf buf) {
        int size = buf.m_130242_();
        HashSet set = Sets.newHashSet();
        for (int i = 0; i < size; ++i) {
            set.add(buf.m_130277_());
        }
        return set;
    }

    public static void writeStringList(List<String> list, FriendlyByteBuf buf) {
        buf.m_130130_(list.size());
        for (String s : list) {
            buf.m_130070_(s);
        }
    }

    public static List<String> readStringList(FriendlyByteBuf buf) {
        int size = buf.m_130242_();
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < size; ++i) {
            list.add(buf.m_130277_());
        }
        return list;
    }

    public static void writeObject2FloatOpenHashMap(Object2FloatOpenHashMap<String> map, FriendlyByteBuf buf) {
        buf.m_130130_(map.size());
        map.forEach((key, value) -> {
            buf.m_130070_(key);
            buf.writeFloat(value.floatValue());
        });
    }

    public static Object2FloatOpenHashMap<String> readObject2FloatOpenHashMap(FriendlyByteBuf buf) {
        int size = buf.m_130242_();
        Object2FloatOpenHashMap map = new Object2FloatOpenHashMap();
        for (int i = 0; i < size; ++i) {
            map.put((Object)buf.m_130277_(), buf.readFloat());
        }
        return map;
    }

    public static void writeSites(Map<String, List<String>> sites, FriendlyByteBuf buf) {
        buf.m_130130_(sites.size());
        sites.forEach((key, value) -> {
            buf.m_130070_(key);
            ByteBufUtils.writeStringList(value, buf);
        });
    }

    public static Map<String, List<String>> readSites(FriendlyByteBuf buf) {
        int size = buf.m_130242_();
        LinkedHashMap sites = Maps.newLinkedHashMap();
        for (int i = 0; i < size; ++i) {
            sites.put(buf.m_130277_(), ByteBufUtils.readStringList(buf));
        }
        return sites;
    }
}

