/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public final class RenderHelper {
    public static void renderFloatingText(PoseStack poseStack, String text, Vec3 vec, int color, float scale, float yOffset) {
        RenderHelper.renderFloatingText(poseStack, text, vec.f_82479_ + 0.5, vec.f_82480_ + 1.5, vec.f_82481_ + 0.5, color, scale, true, yOffset, true);
    }

    public static void renderFloatingText(PoseStack poseStack, String text, double x, double y, double z, int color, float scale, boolean center, float yOffset, boolean seeThrough) {
        Minecraft minecraft = Minecraft.m_91087_();
        MultiBufferSource.BufferSource buffer = minecraft.m_91269_().m_110104_();
        Camera camera = minecraft.f_91063_.m_109153_();
        if (camera.m_90593_()) {
            Font font = minecraft.f_91062_;
            double viewX = camera.m_90583_().f_82479_;
            double viewY = camera.m_90583_().f_82480_;
            double viewZ = camera.m_90583_().f_82481_;
            poseStack.m_85836_();
            poseStack.m_252880_((float)(x - viewX), (float)(y - viewY) + 0.07f, (float)(z - viewZ));
            poseStack.m_252931_(new Matrix4f().rotation((Quaternionfc)camera.m_253121_()));
            poseStack.m_85841_(-scale, -scale, scale);
            float fontX = center ? (float)(-font.m_92895_(text)) / 2.0f : 0.0f;
            font.m_271703_(text, fontX, yOffset, color, false, poseStack.m_85850_().m_252922_(), (MultiBufferSource)buffer, seeThrough ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, 0, 0xF000F0);
            poseStack.m_85849_();
            buffer.m_109911_();
        }
    }

    public static void renderLine(PoseStack poseStack, VertexConsumer consumer, Vec3 start, Vec3 end, float red, float green, float blue) {
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        Matrix3f matrix3f = poseStack.m_85850_().m_252943_();
        consumer.m_252986_(matrix4f, (float)start.f_82479_, (float)start.f_82480_, (float)start.f_82481_).m_85950_(red, green, blue, 1.0f).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix4f, (float)end.f_82479_, (float)end.f_82480_, (float)end.f_82481_).m_85950_(red, green, blue, 1.0f).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix4f, (float)start.f_82479_, (float)start.f_82480_, (float)start.f_82481_).m_85950_(red, green, blue, 1.0f).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix4f, (float)end.f_82479_, (float)end.f_82480_, (float)end.f_82481_).m_85950_(red, green, blue, 1.0f).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix4f, (float)start.f_82479_, (float)start.f_82480_, (float)start.f_82481_).m_85950_(red, green, blue, 1.0f).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix4f, (float)end.f_82479_, (float)end.f_82480_, (float)end.f_82481_).m_85950_(red, green, blue, 1.0f).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
    }

    public static void renderCylinder(PoseStack poseStack, VertexConsumer consumer, Vec3 centerPos, double radius, int precision, float red, float green, float blue) {
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        Matrix3f matrix3f = poseStack.m_85850_().m_252943_();
        double precisionAngle = Math.PI * 2 / (double)precision;
        for (int i = precision; i >= 0; --i) {
            double x1 = centerPos.f_82479_ + radius * Math.cos((double)i * precisionAngle);
            double x2 = centerPos.f_82479_ + radius * Math.cos((double)(i - 1) * precisionAngle);
            double y = centerPos.f_82480_;
            double z1 = centerPos.f_82481_ + radius * Math.sin((double)i * precisionAngle);
            double z2 = centerPos.f_82481_ + radius * Math.sin((double)(i - 1) * precisionAngle);
            consumer.m_252986_(matrix4f, (float)x1, (float)y, (float)z1).m_85950_(red, green, blue, 1.0f).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
            consumer.m_252986_(matrix4f, (float)x2, (float)y, (float)z2).m_85950_(red, green, blue, 1.0f).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
            consumer.m_252986_(matrix4f, (float)x1, (float)y, (float)z1).m_85950_(red, green, blue, 1.0f).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            consumer.m_252986_(matrix4f, (float)x2, (float)y, (float)z2).m_85950_(red, green, blue, 1.0f).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            consumer.m_252986_(matrix4f, (float)x1, (float)y, (float)z1).m_85950_(red, green, blue, 1.0f).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
            consumer.m_252986_(matrix4f, (float)x2, (float)y, (float)z2).m_85950_(red, green, blue, 1.0f).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        }
    }
}

