/*
 * Decompiled with CFR 0.152.
 */
package com.cak.trading_floor.mixin;

import com.cak.trading_floor.content.trading_depot.CommonTradingDepotBlockEntity;
import com.cak.trading_floor.content.trading_depot.behavior.CommonTradingDepotBehaviorAccess;
import com.cak.trading_floor.foundation.AttachedTradingDepotFinder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.WorkAtPoi;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WorkAtPoi.class})
public class WorkAtPoiMixin {
    @Shadow
    private long f_24804_;

    @Inject(method={"checkExtraStartConditions(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/npc/Villager;)Z"}, at={@At(value="TAIL")})
    public void checkExtraStartConditions(ServerLevel level, Villager owner, CallbackInfoReturnable<Boolean> cir) {
        boolean hasReducedCooldown = false;
        Optional jobSite = owner.m_6274_().m_21952_(MemoryModuleType.f_26360_);
        if (jobSite.isEmpty()) {
            return;
        }
        BlockPos jobSitePos = ((GlobalPos)jobSite.get()).m_122646_();
        for (BlockPos pos : AttachedTradingDepotFinder.lookForTradingDepots((LevelAccessor)level, jobSitePos)) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (!(blockEntity instanceof CommonTradingDepotBlockEntity)) continue;
            CommonTradingDepotBlockEntity tbe = (CommonTradingDepotBlockEntity)blockEntity;
            hasReducedCooldown = true;
        }
        if (hasReducedCooldown) {
            this.f_24804_ -= 2000L;
        }
    }

    @Inject(method={"useWorkstation"}, at={@At(value="HEAD")})
    public void useWorkstation(ServerLevel level, Villager villager, CallbackInfo ci) {
        this.trading_floor$innerUseWorkstation(level, villager, ci);
    }

    @Unique
    private void trading_floor$innerUseWorkstation(ServerLevel level, Villager villager, CallbackInfo ci) {
        Optional jobSite = villager.m_6274_().m_21952_(MemoryModuleType.f_26360_);
        if (jobSite.isEmpty()) {
            return;
        }
        BlockPos jobSitePos = ((GlobalPos)jobSite.get()).m_122646_();
        List<BlockPos> tradingDepotPositions = AttachedTradingDepotFinder.lookForTradingDepots((LevelAccessor)level, jobSitePos);
        List<CommonTradingDepotBlockEntity> tradingDepots = tradingDepotPositions.stream().map(pos -> (CommonTradingDepotBlockEntity)level.m_7702_(pos)).filter(Objects::nonNull).filter(CommonTradingDepotBlockEntity::hasInputStack).toList();
        List<CommonTradingDepotBehaviorAccess> tradingDepotBehaviours = tradingDepots.stream().map(CommonTradingDepotBlockEntity::getCommonTradingDepotBehaviour).toList();
        tradingDepots.forEach(depot -> depot.tryTradeWith(villager, tradingDepotBehaviours));
    }
}

