/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.capability;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import com.tiviacz.travelersbackpack.capability.TravelersBackpackCapability;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class CapabilityUtils {
    public static final int[] LOAD_ALL = new int[]{1, 1, 1};
    public static final int[] NO_ITEMS = new int[]{0, 0, 0};
    public static final int[] UPGRADES_ONLY = new int[]{0, 1, 0};
    public static final int[] TOOLS_ONLY = new int[]{0, 0, 1};

    public static LazyOptional<ITravelersBackpack> getCapability(Player player) {
        if (player == null) {
            return LazyOptional.empty();
        }
        return player.getCapability(TravelersBackpackCapability.TRAVELERS_BACKPACK_CAPABILITY, TravelersBackpackCapability.DEFAULT_FACING);
    }

    public static void synchronise(Player player) {
        CapabilityUtils.getCapability(player).ifPresent(ITravelersBackpack::synchronise);
    }

    public static boolean isWearingBackpack(Player player) {
        if (TravelersBackpack.enableIntegration()) {
            if (CuriosApi.getCuriosInventory((LivingEntity)player).isPresent() && CuriosApi.getCuriosInventory((LivingEntity)player).resolve().isPresent()) {
                return ((ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)player).resolve().get()).isEquipped(t -> t.m_41720_() instanceof TravelersBackpackItem);
            }
            return false;
        }
        if (CapabilityUtils.getCapability(player).isPresent()) {
            return ((ITravelersBackpack)CapabilityUtils.getCapability(player).resolve().get()).hasBackpack() && ((ITravelersBackpack)CapabilityUtils.getCapability(player).resolve().get()).getBackpack().m_41720_() instanceof TravelersBackpackItem;
        }
        return false;
    }

    public static ItemStack getWearingBackpack(Player player) {
        if (TravelersBackpack.enableIntegration()) {
            return CapabilityUtils.isWearingBackpack(player) ? ((SlotResult)((ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)player).resolve().get()).findFirstCurio(t -> t.m_41720_() instanceof TravelersBackpackItem).get()).stack() : ItemStack.f_41583_;
        }
        return CapabilityUtils.isWearingBackpack(player) ? ((ITravelersBackpack)CapabilityUtils.getCapability(player).resolve().get()).getBackpack() : ItemStack.f_41583_;
    }

    public static void equipBackpack(Player player, ItemStack stack) {
        if (CapabilityUtils.getCapability(player).isPresent() && !CapabilityUtils.isWearingBackpack(player)) {
            CapabilityUtils.getCapability(player).ifPresent(attachment -> attachment.equipBackpack(stack));
            player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_11678_, SoundSource.PLAYERS, 1.0f, (1.0f + (player.m_9236_().f_46441_.m_188501_() - player.m_9236_().f_46441_.m_188501_()) * 0.2f) * 0.7f);
            CapabilityUtils.synchronise(player);
        }
    }

    @Nullable
    public static BackpackWrapper getBackpackWrapper(Player player, ItemStack stack) {
        return CapabilityUtils.getBackpackWrapper(player, stack, LOAD_ALL);
    }

    @Nullable
    public static BackpackWrapper getBackpackWrapper(Player player, ItemStack stack, int[] dataLoad) {
        if (TravelersBackpack.enableIntegration()) {
            if (CapabilityUtils.isWearingBackpack(player)) {
                return BackpackWrapper.getBackpackWrapper(player, stack, dataLoad);
            }
            return null;
        }
        if (CapabilityUtils.isWearingBackpack(player)) {
            return CapabilityUtils.getCapability(player).map(ITravelersBackpack::getWrapper).orElse(null);
        }
        return null;
    }

    @Nullable
    public static BackpackWrapper getBackpackWrapperArtificial(Player player) {
        return CapabilityUtils.getBackpackWrapper(player, NO_ITEMS);
    }

    @Nullable
    public static BackpackWrapper getBackpackWrapper(Player player) {
        return CapabilityUtils.getBackpackWrapper(player, LOAD_ALL);
    }

    @Nullable
    public static BackpackWrapper getBackpackWrapper(Player player, int[] dataLoad) {
        if (TravelersBackpack.enableIntegration()) {
            if (CapabilityUtils.isWearingBackpack(player)) {
                return BackpackWrapper.getBackpackWrapper(player, CapabilityUtils.getWearingBackpack(player), dataLoad);
            }
            return null;
        }
        if (CapabilityUtils.isWearingBackpack(player)) {
            return CapabilityUtils.getCapability(player).map(ITravelersBackpack::getWrapper).orElse(null);
        }
        return null;
    }
}

