/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common;

import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.blocks.SleepingBagBlock;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.fluids.EffectFluidRegistry;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.BackpackContainer;
import com.tiviacz.travelersbackpack.inventory.BackpackSettingsContainer;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackItemMenu;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackSettingsMenu;
import com.tiviacz.travelersbackpack.inventory.sorter.ContainerSorter;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.items.HoseItem;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.network.ClientboundSyncItemStackPacket;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import com.tiviacz.travelersbackpack.util.PacketDistributorHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemStackHandler;

public class ServerActions {
    public static final int TAB_OPEN = 0;
    public static final int UPGRADE_ENABLED = 1;
    public static final int SHIFT_CLICK_TO_BACKPACK = 2;
    public static final int PLAY_RECORD = 3;

    public static void swapTool(Player player, double scrollDelta) {
        if (CapabilityUtils.isWearingBackpack(player)) {
            int i;
            BackpackWrapper wrapper = CapabilityUtils.getBackpackWrapper(player, CapabilityUtils.TOOLS_ONLY);
            ItemStackHandler inv = wrapper.getTools();
            if (InventoryHelper.isEmpty(inv)) {
                return;
            }
            int toolSlots = inv.getSlots();
            int lastSlot = toolSlots - 1;
            int j = 0;
            for (int i2 = 0; i2 <= lastSlot; ++i2) {
                if (inv.getStackInSlot(i2).m_41619_()) continue;
                ++j;
            }
            ItemStack[] tools = new ItemStack[j];
            int slot = 0;
            for (i = 0; i <= j - 1; ++i) {
                tools[slot] = inv.getStackInSlot(i).m_41777_();
                ++slot;
            }
            ServerActions.swapTool(scrollDelta, tools, player);
            slot = 0;
            for (i = 0; i <= j - 1; ++i) {
                inv.setStackInSlot(i, tools[slot]);
                ++slot;
            }
            wrapper.sendDataToClients("ToolsInventory");
        }
    }

    public static void swapTool(double delta, ItemStack[] tools, Player player) {
        int i;
        ItemStack tempStack;
        if (delta > 0.0) {
            tempStack = tools[0];
            for (i = 0; i <= tools.length - 1; ++i) {
                if (i + 1 > tools.length - 1) {
                    tools[tools.length - 1] = player.m_21205_();
                    player.m_21008_(InteractionHand.MAIN_HAND, tempStack);
                    continue;
                }
                tools[i] = tools[i + 1];
            }
        }
        if (delta < 0.0) {
            tempStack = tools[tools.length - 1];
            for (i = tools.length - 1; i >= 0; --i) {
                if (i - 1 < 0) {
                    tools[0] = player.m_21205_();
                    player.m_21008_(InteractionHand.MAIN_HAND, tempStack);
                    continue;
                }
                tools[i] = tools[i - 1];
            }
        }
    }

    public static void equipBackpack(Player player, boolean equip) {
        if (equip) {
            ServerActions.equipBackpack(player);
        } else {
            ServerActions.unequipBackpack(player);
        }
    }

    public static void equipBackpack(Player player) {
        Level level = player.m_9236_();
        if (!level.f_46443_) {
            if (!CapabilityUtils.isWearingBackpack(player)) {
                if (player.f_36096_ instanceof BackpackItemMenu) {
                    player.m_6915_();
                }
                ItemStack stack = player.m_21205_().m_41777_();
                CapabilityUtils.getCapability(player).ifPresent(attachment -> {
                    attachment.equipBackpack(stack);
                    attachment.synchronise();
                });
                player.m_21205_().m_41774_(1);
                level.m_5594_(null, player.m_20183_(), SoundEvents.f_11678_, SoundSource.PLAYERS, 1.0f, (1.0f + (level.m_213780_().m_188501_() - level.m_213780_().m_188501_()) * 0.2f) * 0.7f);
            } else {
                player.m_6915_();
                player.m_213846_((Component)Component.m_237115_((String)"action.travelersbackpack.equip_otherbackpack"));
            }
        }
    }

    public static void unequipBackpack(Player player) {
        Level level = player.m_9236_();
        if (!level.f_46443_ && CapabilityUtils.isWearingBackpack(player)) {
            if (player.f_36096_ instanceof BackpackItemMenu) {
                player.m_6915_();
            }
            ItemStack backpack = CapabilityUtils.getWearingBackpack(player).m_41777_();
            if (!player.m_150109_().m_36054_(backpack)) {
                player.m_213846_((Component)Component.m_237115_((String)"action.travelersbackpack.unequip_nospace"));
                return;
            }
            CapabilityUtils.getCapability(player).ifPresent(attachment -> {
                attachment.equipBackpack(new ItemStack((ItemLike)Items.f_41852_, 0));
                attachment.synchronise();
            });
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_11678_, SoundSource.PLAYERS, 1.05f, (1.0f + (level.m_213780_().m_188501_() - level.m_213780_().m_188501_()) * 0.2f) * 0.7f);
        }
    }

    public static void openBackpackFromSlot(ServerPlayer player, int index, boolean fromSlot) {
        ItemStack backpackStack;
        if (index >= 0 && index < player.m_150109_().f_35974_.size() && (backpackStack = (ItemStack)player.m_150109_().f_35974_.get(index)).m_41720_() instanceof TravelersBackpackItem && !((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.allowOnlyEquippedBackpack.get()).booleanValue() && (!fromSlot || ((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.allowOpeningFromSlot.get()).booleanValue())) {
            BackpackContainer.openBackpack(player, backpackStack, 1, index);
        }
    }

    public static void openBackpackSettings(ServerPlayer player, int entityId, boolean open) {
        if (player.m_19879_() == entityId) {
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof BackpackBaseMenu) {
                BackpackBaseMenu menu = (BackpackBaseMenu)abstractContainerMenu;
                if (open) {
                    if (menu.getWrapper().getScreenID() == 3) {
                        BlockEntity blockEntity = player.m_9236_().m_7702_(menu.getWrapper().getBackpackPos());
                        if (blockEntity instanceof BackpackBlockEntity) {
                            backpackBlockEntity = (BackpackBlockEntity)blockEntity;
                            ((BackpackBlockEntity)((Object)backpackBlockEntity)).openSettings((Player)player, (MenuProvider)backpackBlockEntity, menu.getWrapper().getBackpackPos());
                        }
                    } else {
                        BackpackSettingsContainer.openSettings(player, menu.getWrapper().getBackpackStack(), menu.getWrapper().getScreenID(), menu.getWrapper().getBackpackSlotIndex());
                    }
                }
            } else {
                backpackBlockEntity = player.f_36096_;
                if (backpackBlockEntity instanceof BackpackSettingsMenu) {
                    BackpackSettingsMenu menu = (BackpackSettingsMenu)((Object)backpackBlockEntity);
                    if (!open) {
                        if (menu.getWrapper().getScreenID() == 3) {
                            BlockEntity blockEntity = player.m_9236_().m_7702_(menu.getWrapper().getBackpackPos());
                            if (blockEntity instanceof BackpackBlockEntity) {
                                backpackBlockEntity = (BackpackBlockEntity)blockEntity;
                                ((BackpackBlockEntity)((Object)backpackBlockEntity)).openBackpack((Player)player, (MenuProvider)backpackBlockEntity, menu.getWrapper().getBackpackPos());
                            }
                        } else {
                            BackpackContainer.openBackpack(player, menu.getWrapper().getBackpackStack(), menu.getWrapper().getScreenID(), menu.getWrapper().getBackpackSlotIndex());
                        }
                    }
                }
            }
        }
    }

    public static void modifyUpgradeTab(ServerPlayer player, int slot, boolean open, int packetType) {
        BackpackBaseMenu menu;
        ItemStack upgradeStack;
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof BackpackBaseMenu && !(upgradeStack = (menu = (BackpackBaseMenu)abstractContainerMenu).getWrapper().getUpgrades().getStackInSlot(slot)).m_41619_()) {
            ItemStack updateStack = upgradeStack.m_41777_();
            NbtHelper.set(updateStack, ServerActions.getPacketType(packetType), open);
            menu.getWrapper().getUpgrades().setStackInSlot(slot, updateStack);
            if (packetType == 1 && menu.getWrapper().getUpgradeManager().hasUpgradeInSlot(slot)) {
                ((Optional)menu.getWrapper().getUpgradeManager().mappedUpgrades.get((Object)slot)).ifPresent(upgradeBase -> {
                    if (upgradeBase instanceof IEnable) {
                        IEnable upg = (IEnable)((Object)upgradeBase);
                        upg.setEnabled(open);
                    }
                });
            }
        }
    }

    public static String getPacketType(int type) {
        return switch (type) {
            case 0 -> "TabOpen";
            case 1 -> "UpgradeEnabled";
            case 2 -> "ShiftClickToBackpack";
            case 3 -> "IsPlaying";
            default -> "TabOpen";
        };
    }

    public static void removeBackpackUpgrade(ServerPlayer player, int slot) {
        BackpackBaseMenu menu;
        BackpackWrapper wrapper;
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof BackpackBaseMenu && !(wrapper = (menu = (BackpackBaseMenu)abstractContainerMenu).getWrapper()).getUpgrades().getStackInSlot(slot).m_41619_()) {
            Optional upgrade = (Optional)wrapper.getUpgradeManager().mappedUpgrades.get((Object)slot);
            ItemStack upgradeStack = wrapper.getUpgrades().getStackInSlot(slot).m_41777_();
            NbtHelper.set(upgradeStack, "TabOpen", false);
            wrapper.getUpgrades().setStackInSlot(slot, ItemStack.f_41583_);
            upgrade.ifPresent(upgradeBase -> upgradeBase.onUpgradeRemoved(upgradeStack));
            if (!player.m_150109_().m_36054_(upgradeStack)) {
                player.m_36176_(upgradeStack, true);
            }
            wrapper.saveHandler.run();
        }
    }

    public static void switchAbilitySlider(ServerPlayer player, boolean sliderValue) {
        BackpackWrapper wrapper = CapabilityUtils.getBackpackWrapperArtificial((Player)player);
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof BackpackBaseMenu) {
            BackpackBaseMenu menu = (BackpackBaseMenu)abstractContainerMenu;
            wrapper = menu.getWrapper();
        }
        wrapper.setDataAndSync("AbilityEnabled", sliderValue);
        if (wrapper.getBackpackOwner() != null) {
            if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_REMOVAL_LIST, wrapper.getBackpackStack()) && !sliderValue) {
                BackpackAbilities.ABILITIES.abilityRemoval(wrapper.getBackpackStack(), wrapper.getBackpackOwner());
            }
            if (wrapper.getBackpackStack().m_41720_() == ModItems.CHICKEN_TRAVELERS_BACKPACK.get() && wrapper.getCooldown() <= 0) {
                BackpackAbilities.ABILITIES.chickenAbility(wrapper.getBackpackStack(), wrapper.getBackpackOwner(), true);
            }
        }
    }

    public static void showToolSlots(ServerPlayer player, boolean show) {
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof BackpackBaseMenu) {
            BackpackBaseMenu menu = (BackpackBaseMenu)abstractContainerMenu;
            menu.getWrapper().setDataAndSync("ShowToolSlots", show);
        }
    }

    public static void sortBackpack(Player player, int button, boolean shiftPressed) {
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof BackpackBaseMenu) {
            BackpackBaseMenu menu = (BackpackBaseMenu)abstractContainerMenu;
            ContainerSorter.selectSort(menu.getWrapper(), player, button, shiftPressed);
        }
    }

    public static void toggleVisibility(Player player) {
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof BackpackSettingsMenu) {
            BackpackSettingsMenu menu = (BackpackSettingsMenu)abstractContainerMenu;
            boolean visibility = NbtHelper.getOrDefault(menu.getWrapper().getBackpackStack(), "IsVisible", true);
            menu.getWrapper().setDataAndSync("IsVisible", !visibility);
        }
    }

    public static void toggleButtonsVisibility(Player player) {
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof BackpackBaseMenu) {
            BackpackBaseMenu menu = (BackpackBaseMenu)abstractContainerMenu;
            boolean current = menu.getWrapper().showMoreButtons();
            menu.getWrapper().setDataAndSync("ShowMoreButtons", !current);
        }
    }

    public static void toggleSleepingBag(Player player, BlockPos pos, boolean isEquipped) {
        Level level = player.m_9236_();
        if (isEquipped) {
            BlockPos sleepingBagPos2;
            BlockPos sleepingBagPos1 = pos.m_121945_(player.m_6350_());
            boolean canPlace = ServerActions.placeAndUseSleepingBag(player, sleepingBagPos1, sleepingBagPos2 = sleepingBagPos1.m_121945_(player.m_6350_()), pos, level, player.m_6350_());
            if (!canPlace) {
                player.m_213846_((Component)Component.m_237115_((String)"action.travelersbackpack.deploy_sleeping_bag"));
                player.m_6915_();
                return;
            }
            if (!level.f_46443_ && player instanceof ServerPlayer) {
                player.m_7720_(pos.m_121945_(player.m_6350_()).m_121945_(player.m_6350_())).ifLeft(bedSleepingProblem -> {
                    if (bedSleepingProblem.m_36423_() != null) {
                        player.m_5661_(bedSleepingProblem.m_36423_(), true);
                        if (level.m_8055_(sleepingBagPos1).m_60734_() instanceof SleepingBagBlock) {
                            level.m_46597_(sleepingBagPos1, Blocks.f_50016_.m_49966_());
                        }
                        if (level.m_8055_(sleepingBagPos2).m_60734_() instanceof SleepingBagBlock) {
                            level.m_46597_(sleepingBagPos2, Blocks.f_50016_.m_49966_());
                        }
                    }
                });
                player.m_6915_();
            }
        } else {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof BackpackBlockEntity) {
                BackpackBlockEntity blockEntity2 = (BackpackBlockEntity)blockEntity;
                if (!blockEntity2.isSleepingBagDeployed()) {
                    if (!blockEntity2.deploySleepingBag(level, pos)) {
                        player.m_213846_((Component)Component.m_237115_((String)"action.travelersbackpack.deploy_sleeping_bag"));
                    }
                } else {
                    blockEntity2.removeSleepingBag(level, blockEntity2.getBlockDirection());
                }
                if (!level.f_46443_) {
                    player.m_6915_();
                }
            }
        }
    }

    public static boolean placeAndUseSleepingBag(Player player, BlockPos sleepingBagPos1, BlockPos sleepingBagPos2, BlockPos pos, Level level, Direction direction) {
        if (!player.m_20096_() || level.m_8055_(sleepingBagPos1.m_7495_()).m_60795_() || level.m_8055_(sleepingBagPos1.m_7495_()).m_60734_() instanceof LiquidBlock || !BedBlock.m_49488_((Level)level)) {
            return false;
        }
        ItemStack backpack = CapabilityUtils.getWearingBackpack(player);
        if (BackpackBlockEntity.canPlaceSleepingBag(sleepingBagPos2, level) && BackpackBlockEntity.canPlaceSleepingBag(sleepingBagPos1, level)) {
            level.m_5594_(null, sleepingBagPos2, SoundEvents.f_12642_, SoundSource.BLOCKS, 0.5f, 1.0f);
            if (!level.f_46443_) {
                BlockState sleepingBagState = BackpackBlockEntity.getProperSleepingBag(NbtHelper.getOrDefault(backpack, "SleepingBagColor", DyeColor.RED.m_41060_()));
                level.m_7731_(sleepingBagPos1, (BlockState)((BlockState)((BlockState)sleepingBagState.m_61124_((Property)SleepingBagBlock.f_54117_, (Comparable)direction)).m_61124_(SleepingBagBlock.PART, (Comparable)BedPart.FOOT)).m_61124_((Property)SleepingBagBlock.CAN_DROP, (Comparable)Boolean.valueOf(false)), 3);
                level.m_7731_(sleepingBagPos2, (BlockState)((BlockState)((BlockState)sleepingBagState.m_61124_((Property)SleepingBagBlock.f_54117_, (Comparable)direction)).m_61124_(SleepingBagBlock.PART, (Comparable)BedPart.HEAD)).m_61124_((Property)SleepingBagBlock.CAN_DROP, (Comparable)Boolean.valueOf(false)), 3);
                level.m_46672_(pos, sleepingBagState.m_60734_());
                level.m_46672_(sleepingBagPos2, sleepingBagState.m_60734_());
            }
            return true;
        }
        return false;
    }

    public static int throwPotion(Level level, Player player, ItemStack potionStack, boolean isSplash) {
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), isSplash ? SoundEvents.f_12437_ : SoundEvents.f_12091_, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.m_213780_().m_188501_() * 0.4f + 0.8f));
        if (!level.f_46443_) {
            ThrownPotion thrownpotion = new ThrownPotion(level, (LivingEntity)player);
            thrownpotion.m_37446_(potionStack);
            thrownpotion.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), -20.0f, 0.5f, 1.0f);
            level.m_7967_((Entity)thrownpotion);
        }
        if (!player.m_150110_().f_35937_) {
            return 250;
        }
        return 0;
    }

    public static boolean setFluidEffect(Level level, Player player, FluidTank tank) {
        FluidStack fluidStack = tank.getFluid();
        boolean done = false;
        if (EffectFluidRegistry.hasExecutableEffects(fluidStack, level, (Entity)player)) {
            done = EffectFluidRegistry.executeEffects(fluidStack, (Entity)player, level);
        }
        return done;
    }

    public static void switchHoseMode(Player player, double scrollDelta) {
        ItemStack hose = player.m_21205_();
        if (hose.m_41720_() instanceof HoseItem) {
            List<Integer> settings = NbtHelper.getOrDefault(hose, "HoseModes", List.of(Integer.valueOf(1), Integer.valueOf(1)));
            if (scrollDelta > 0.0) {
                int nextMode = settings.get(0) + 1;
                NbtHelper.set(hose, "HoseModes", List.of(Integer.valueOf(nextMode == 4 ? 1 : nextMode), settings.get(1)));
            } else if (scrollDelta < 0.0) {
                int nextMode = settings.get(0) - 1;
                NbtHelper.set(hose, "HoseModes", List.of(Integer.valueOf(nextMode == 0 ? 3 : nextMode), settings.get(1)));
            }
        }
        if (!player.m_9236_().f_46443_) {
            CompoundTag builder = new CompoundTag();
            if (hose.m_41782_() && hose.m_41783_().m_128441_("HoseModes")) {
                builder.m_128365_("HoseModes", (Tag)hose.m_41783_().m_128437_("HoseModes", 3));
            }
            PacketDistributorHelper.sendToPlayer((ServerPlayer)player, new ClientboundSyncItemStackPacket(player.m_19879_(), player.m_150109_().f_35977_, hose, builder));
        }
    }

    public static void toggleHoseTank(Player player) {
        ItemStack hose = player.m_21205_();
        if (hose.m_41720_() instanceof HoseItem) {
            List<Integer> settings = NbtHelper.getOrDefault(hose, "HoseModes", List.of(Integer.valueOf(1), Integer.valueOf(1)));
            if (settings.get(1) == 1) {
                NbtHelper.set(hose, "HoseModes", List.of(settings.get(0), Integer.valueOf(2)));
            } else {
                NbtHelper.set(hose, "HoseModes", List.of(settings.get(0), Integer.valueOf(1)));
            }
        }
        if (!player.m_9236_().f_46443_) {
            CompoundTag builder = new CompoundTag();
            if (hose.m_41782_() && hose.m_41783_().m_128441_("HoseModes")) {
                builder.m_128365_("HoseModes", (Tag)hose.m_41783_().m_128437_("HoseModes", 3));
            }
            PacketDistributorHelper.sendToPlayer((ServerPlayer)player, new ClientboundSyncItemStackPacket(player.m_19879_(), player.m_150109_().f_35977_, hose, builder));
        }
    }
}

