/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.vanillin.compose;

import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visual.EntityVisual;
import dev.engine_room.flywheel.api.visual.TickableVisual;
import dev.engine_room.flywheel.api.visual.Visual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.visual.AbstractVisual;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import dev.engine_room.flywheel.lib.visual.SimpleTickableVisual;
import dev.engine_room.vanillin.compose.ConfiguredElement;
import dev.engine_room.vanillin.compose.VisualizationPredicate;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class ComposableEntityVisual<T extends Entity>
extends AbstractVisual
implements EntityVisual<T>,
SimpleTickableVisual,
SimpleDynamicVisual {
    private final T entity;
    private final Controller<T> controller;
    @Nullable
    private final Visual[] visuals;

    public ComposableEntityVisual(VisualizationContext ctx, T entity, float partialTick, Controller<T> controller) {
        super(ctx, entity.m_9236_(), partialTick);
        this.entity = entity;
        this.controller = controller;
        this.visuals = new Visual[controller.elements.length];
        this.updateElements(partialTick);
    }

    public void tick(TickableVisual.Context context) {
        this.updateElements(0.0f);
        for (Visual visual : this.visuals) {
            if (!(visual instanceof SimpleTickableVisual)) continue;
            SimpleTickableVisual tickable = (SimpleTickableVisual)visual;
            tickable.tick(context);
        }
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        this.updateElements(ctx.partialTick());
        for (Visual visual : this.visuals) {
            if (!(visual instanceof SimpleDynamicVisual)) continue;
            SimpleDynamicVisual dynamic = (SimpleDynamicVisual)visual;
            dynamic.beginFrame(ctx);
        }
    }

    private void updateElements(float partialTick) {
        if (!this.controller.predicate.shouldVisualize(this.visualizationContext, this.entity)) {
            for (int i = 0; i < this.visuals.length; ++i) {
                if (this.visuals[i] == null) continue;
                this.visuals[i].delete();
                this.visuals[i] = null;
            }
            return;
        }
        for (int i = 0; i < this.controller.elements.length; ++i) {
            boolean exists;
            ConfiguredElement<T> element = this.controller.elements[i];
            boolean shouldExist = element.shouldVisualize(this.visualizationContext, this.entity);
            boolean bl = exists = this.visuals[i] != null;
            if (shouldExist && !exists) {
                this.visuals[i] = element.create(this.visualizationContext, this.entity, partialTick);
                continue;
            }
            if (shouldExist || !exists) continue;
            this.visuals[i].delete();
            this.visuals[i] = null;
        }
    }

    protected void _delete() {
        for (Visual visual : this.visuals) {
            if (visual == null) continue;
            visual.delete();
        }
    }

    public static class Controller<T> {
        private final ConfiguredElement<? super T>[] elements;
        private final VisualizationPredicate<T> predicate;

        public Controller(ConfiguredElement<? super T>[] elements, VisualizationPredicate<T> predicate) {
            this.elements = elements;
            this.predicate = predicate;
        }
    }
}

