/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.vanillin.item;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.engine_room.flywheel.api.material.Material;
import dev.engine_room.flywheel.api.material.Transparency;
import dev.engine_room.flywheel.api.model.Mesh;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.api.vertex.VertexList;
import dev.engine_room.flywheel.lib.material.Materials;
import dev.engine_room.flywheel.lib.material.SimpleMaterial;
import dev.engine_room.flywheel.lib.memory.MemoryBlock;
import dev.engine_room.flywheel.lib.model.ModelUtil;
import dev.engine_room.flywheel.lib.model.SimpleModel;
import dev.engine_room.flywheel.lib.model.SimpleQuadMesh;
import dev.engine_room.flywheel.lib.model.SingleMeshModel;
import dev.engine_room.flywheel.lib.util.RendererReloadCache;
import dev.engine_room.flywheel.lib.vertex.FullVertexView;
import dev.engine_room.vanillin.Vanillin;
import dev.engine_room.vanillin.VanillinXplat;
import dev.engine_room.vanillin.mixin.item.ItemOverridesAccessor;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.MultiPartBakedModel;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.client.resources.model.WeightedBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.system.MemoryStack;

public class ItemModels {
    public static final TagKey<Item> NO_INSTANCING = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)Vanillin.rl("no_instancing"));
    private static final Model EMPTY_MODEL = new SimpleModel(List.of());
    private static final RendererReloadCache<BakedMeshKey, Mesh> MESH_CACHE = new RendererReloadCache(key -> ItemModels.bakeMesh(key.model(), key.displayContext()));
    private static final RendererReloadCache<BakedModelKey, Model> MODEL_CACHE = new RendererReloadCache(key -> ItemModels.bakeModel(key.model(), key.displayContext(), key.material(), key.foil()));
    private static final ModelResourceLocation TRIDENT_MODEL = ModelResourceLocation.m_245263_((String)"trident", (String)"inventory");
    private static final ModelResourceLocation SPYGLASS_MODEL = ModelResourceLocation.m_245263_((String)"spyglass", (String)"inventory");
    @Nullable
    private static final Direction[] DIRECTIONS = new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, null};
    private static final Set<ResourceLocation> ALLOWED_OVERRIDES = new HashSet<ResourceLocation>();

    public static boolean isSupported(ItemStack stack) {
        return !stack.m_204117_(NO_INSTANCING) && ItemModels.doesNotHaveItemColors(stack.m_41720_()) && ItemModels.isSupported(ItemModels.getModel(stack));
    }

    private static boolean doesNotHaveItemColors(Item item) {
        return VanillinXplat.INSTANCE.itemColors(item) == null;
    }

    public static BakedModel getModel(ItemStack stack) {
        return Minecraft.m_91087_().m_91291_().m_115103_().m_109406_(stack);
    }

    @Nullable
    public static BakedModel getActualBakedModel(@Nullable ClientLevel clientLevel, ItemStack itemStack, ItemDisplayContext displayContext) {
        boolean notEquipped;
        if (itemStack.m_41619_()) {
            return null;
        }
        BakedModel baseModel = ItemModels.getModel(itemStack);
        ItemOverrides overrides = baseModel.m_7343_();
        BakedModel model = overrides.m_173464_(baseModel, itemStack, clientLevel, null, 0);
        if (model == null) {
            model = baseModel;
        }
        boolean bl = notEquipped = displayContext == ItemDisplayContext.GUI || displayContext == ItemDisplayContext.GROUND || displayContext == ItemDisplayContext.FIXED;
        if (model.m_7521_() || itemStack.m_150930_(Items.f_42713_) && !notEquipped) {
            return null;
        }
        if (notEquipped) {
            if (itemStack.m_150930_(Items.f_42713_)) {
                model = Minecraft.m_91087_().m_91291_().m_115103_().m_109393_().m_119422_(TRIDENT_MODEL);
            } else if (itemStack.m_150930_(Items.f_151059_)) {
                model = Minecraft.m_91087_().m_91291_().m_115103_().m_109393_().m_119422_(SPYGLASS_MODEL);
            }
        }
        return model;
    }

    public static boolean isSupported(BakedModel model) {
        Class<?> c;
        if (model.m_7521_()) {
            return false;
        }
        ItemOverrides overrides = model.m_7343_();
        if (overrides != ItemOverrides.f_111734_) {
            ResourceLocation[] properties;
            for (ResourceLocation property : properties = ((ItemOverridesAccessor)overrides).vanillin$properties()) {
                if (ALLOWED_OVERRIDES.contains(property)) continue;
                return false;
            }
        }
        return (c = model.getClass()) == SimpleBakedModel.class || c == MultiPartBakedModel.class || c == WeightedBakedModel.class;
    }

    public static Model get(Level level, ItemStack itemStack, ItemDisplayContext displayContext) {
        ClientLevel clientLevel;
        BakedModel model;
        BlockItem block;
        Item item;
        boolean cull = displayContext == ItemDisplayContext.GUI || displayContext.m_269069_() || !((item = itemStack.m_41720_()) instanceof BlockItem) || !((block = (BlockItem)item).m_40614_() instanceof HalfTransparentBlock) && !(block.m_40614_() instanceof StainedGlassPaneBlock);
        Material material = ModelUtil.getItemMaterial((RenderType)ItemBlockRenderTypes.m_109279_((ItemStack)itemStack, (boolean)cull));
        if (material == null) {
            material = Materials.TRANSLUCENT_ENTITY;
        }
        if (itemStack.m_41720_() instanceof BlockItem && material.transparency() == Transparency.TRANSLUCENT) {
            material = SimpleMaterial.builderOf((Material)material).transparency(Transparency.ORDER_INDEPENDENT).build();
        }
        if ((model = ItemModels.getActualBakedModel(clientLevel = level instanceof ClientLevel ? (ClientLevel)level : null, itemStack, displayContext)) == null) {
            return EMPTY_MODEL;
        }
        return (Model)MODEL_CACHE.get((Object)new BakedModelKey(model, displayContext, material, itemStack.m_41790_()));
    }

    public static Model bakeModel(BakedModel model, ItemDisplayContext displayContext, Material material, boolean foil) {
        Mesh mesh = (Mesh)MESH_CACHE.get((Object)new BakedMeshKey(model, displayContext));
        Object out = foil ? new SimpleModel(List.of(new Model.ConfiguredMesh(material, mesh), new Model.ConfiguredMesh(Materials.GLINT, mesh))) : new SingleMeshModel(mesh, material);
        return out;
    }

    public static Mesh bakeMesh(BakedModel model, ItemDisplayContext displayContext) {
        boolean leftHand = displayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || displayContext == ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
        PoseStack poseStack = new PoseStack();
        model.m_7442_().m_269404_(displayContext).m_111763_(leftHand, poseStack);
        poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
        RandomSource randomSource = RandomSource.m_216327_();
        ArrayList allQuads = new ArrayList();
        for (Direction value : DIRECTIONS) {
            randomSource.m_188584_(42L);
            allQuads.addAll(model.m_213637_(null, value, randomSource));
        }
        int vertexCount = allQuads.size() * 4;
        MemoryBlock memoryBlock = MemoryBlock.mallocTracked((long)((long)vertexCount * 36L));
        FullVertexView meshVertices = new FullVertexView();
        meshVertices.nativeMemoryOwner((Object)memoryBlock);
        meshVertices.ptr(memoryBlock.ptr());
        meshVertices.vertexCount(vertexCount);
        Vector4f position = new Vector4f();
        Vector3f normal = new Vector3f();
        Matrix4f poseMatrix = poseStack.m_85850_().m_252922_();
        Matrix3f normalMatrix = poseStack.m_85850_().m_252943_();
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            ByteBuffer byteBuffer = memoryStack.malloc(DefaultVertexFormat.f_85811_.m_86020_());
            IntBuffer intBuffer = byteBuffer.asIntBuffer();
            int vertex = 0;
            for (BakedQuad quad : allQuads) {
                int[] js = quad.m_111303_();
                Direction direction = quad.m_111306_();
                normal.set((float)direction.m_122429_(), (float)direction.m_122430_(), (float)direction.m_122431_());
                normal.mul((Matrix3fc)normalMatrix);
                int j = js.length / 8;
                for (int k = 0; k < j; ++k) {
                    intBuffer.clear();
                    intBuffer.put(js, k * 8, 8);
                    position.set(byteBuffer.getFloat(0), byteBuffer.getFloat(4), byteBuffer.getFloat(8), 1.0f);
                    position.mul((Matrix4fc)poseMatrix);
                    meshVertices.x(vertex, position.x());
                    meshVertices.y(vertex, position.y());
                    meshVertices.z(vertex, position.z());
                    meshVertices.r(vertex, 1.0f);
                    meshVertices.g(vertex, 1.0f);
                    meshVertices.b(vertex, 1.0f);
                    meshVertices.a(vertex, 1.0f);
                    meshVertices.u(vertex, byteBuffer.getFloat(16));
                    meshVertices.v(vertex, byteBuffer.getFloat(20));
                    meshVertices.overlay(vertex, OverlayTexture.f_118083_);
                    meshVertices.light(vertex, 0);
                    meshVertices.normalX(vertex, normal.x());
                    meshVertices.normalY(vertex, normal.y());
                    meshVertices.normalZ(vertex, normal.z());
                    ++vertex;
                }
            }
        }
        return new SimpleQuadMesh((VertexList)meshVertices);
    }

    static {
        ALLOWED_OVERRIDES.add(new ResourceLocation("lefthanded"));
        ALLOWED_OVERRIDES.add(new ResourceLocation("cooldown"));
        ALLOWED_OVERRIDES.add(ItemModelGenerators.f_265922_);
        ALLOWED_OVERRIDES.add(new ResourceLocation("custom_model_data"));
        ALLOWED_OVERRIDES.add(new ResourceLocation("pull"));
        ALLOWED_OVERRIDES.add(new ResourceLocation("brushing"));
        ALLOWED_OVERRIDES.add(new ResourceLocation("pulling"));
        ALLOWED_OVERRIDES.add(new ResourceLocation("filled"));
        ALLOWED_OVERRIDES.add(new ResourceLocation("charged"));
        ALLOWED_OVERRIDES.add(new ResourceLocation("firework"));
        ALLOWED_OVERRIDES.add(new ResourceLocation("broken"));
        ALLOWED_OVERRIDES.add(new ResourceLocation("cast"));
        ALLOWED_OVERRIDES.add(new ResourceLocation("blocking"));
        ALLOWED_OVERRIDES.add(new ResourceLocation("throwing"));
        ALLOWED_OVERRIDES.add(new ResourceLocation("level"));
        ALLOWED_OVERRIDES.add(new ResourceLocation("tooting"));
    }

    public record BakedModelKey(BakedModel model, ItemDisplayContext displayContext, Material material, boolean foil) {
    }

    public record BakedMeshKey(BakedModel model, ItemDisplayContext displayContext) {
    }
}

