/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.screens.widgets;

import java.net.URI;
import java.util.List;
import me.srrapero720.waterframes.DisplaysConfig;
import me.srrapero720.waterframes.WaterFrames;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import me.srrapero720.waterframes.common.screens.styles.ScreenStyles;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.controls.simple.GuiTextfield;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.gui.style.display.StyleDisplay;
import team.creative.creativecore.common.util.text.TextBuilder;

public class WidgetURLTextField
extends GuiTextfield {
    public WidgetURLTextField(DisplayTile tile) {
        super("url");
        this.setMaxStringLength(2048);
        this.setSuggestion("https://i.imgur.com/1yCDs5C.mp4");
        if (tile != null) {
            this.setText(tile.data.hasUri() ? tile.data.getUri().toString() : "");
        }
    }

    public StyleDisplay getBorder(GuiStyle style, StyleDisplay display) {
        return this.isUrlValid() ? ScreenStyles.BLUE_BORDER : ScreenStyles.RED_BORDER;
    }

    public StyleDisplay getBackground(GuiStyle style, StyleDisplay display) {
        return ScreenStyles.DARK_BLUE_BACKGROUND;
    }

    public List<Component> getTooltip() {
        TextBuilder builder = new TextBuilder();
        if (this.getText().isEmpty()) {
            builder.text(ChatFormatting.BLUE + GuiControl.translate((String)"waterframes.gui.url.tooltip.empty"));
        } else if (!this.isUrlValid()) {
            builder.text(ChatFormatting.RED + GuiControl.translate((String)"waterframes.gui.url.tooltip.invalid_url"));
        } else if (!DisplaysConfig.canSave(this.getPlayer(), this.getText())) {
            builder.text(ChatFormatting.RED + GuiControl.translate((String)"waterframes.gui.url.tooltip.not_whitelisted"));
        }
        List result = builder.build();
        return result.isEmpty() ? null : result;
    }

    public URI getURI() {
        return WaterFrames.createURI(this.getText());
    }

    public boolean isUrlValid() {
        return WaterFrames.createURI(this.getText()) != null;
    }
}

