/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.network.patchs;

import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.watermedia.api.network.patchs.AbstractPatch;
import org.watermedia.core.tools.DataTool;
import org.watermedia.core.tools.NetTool;

public class MediaFirePatch
extends AbstractPatch {
    private static final Pattern PATTERN = Pattern.compile("<a\\s+class=\"input\\s+popsok\"\\s+aria-label=\"Download\\s+file\"\\s+href=\"([^\"]+)\"[^>]*>");

    @Override
    public String platform() {
        return "Mediafire";
    }

    @Override
    public boolean isValid(URI uri) {
        String host = uri.getHost();
        if (host == null) {
            return false;
        }
        String path = uri.getPath();
        if (path == null) {
            return false;
        }
        return host.equals("www.mediafire.com") && path.startsWith("/file/");
    }

    @Override
    public AbstractPatch.Result patch(URI uri, AbstractPatch.Quality prefQuality) throws AbstractPatch.FixingURLException {
        super.patch(uri, prefQuality);
        try {
            HttpURLConnection conn = NetTool.connectToHTTP(uri, "GET");
            int code = conn.getResponseCode();
            switch (code) {
                case 500: {
                    throw new Exception("MediaFire is on fire (literally)");
                }
                case 404: {
                    throw new NullPointerException("MediaFire file is on fire (literally)");
                }
                case 401: 
                case 403: {
                    throw new UnsupportedOperationException("MediaFire placed a firewall to us - URL: " + uri);
                }
            }
            if (code != 200) {
                throw new UnsupportedOperationException("Unexpected fired response from MediaFire (" + code + ") - URL: " + uri);
            }
            String html = new String(DataTool.readAllBytes(conn.getInputStream()), StandardCharsets.UTF_8);
            Matcher matcher = PATTERN.matcher(html);
            if (matcher.find()) {
                return new AbstractPatch.Result(new URI(matcher.group(1)), false, false);
            }
            throw new NullPointerException("No link found in MediaFire page - URL: " + uri);
        }
        catch (Exception e) {
            throw new AbstractPatch.FixingURLException(uri.toString(), (Throwable)e);
        }
    }
}

