/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.item;

import com.yuushya.item.AbstractYuushyaItem;
import com.yuushya.item.BlueprintItem;
import com.yuushya.item.HatItem;
import com.yuushya.item.StructureCreatorItem;
import com.yuushya.registries.YuushyaCreativeModeTab;
import com.yuushya.registries.YuushyaRegistryData;
import com.yuushya.utils.YuushyaUtils;
import net.minecraft.world.item.Item;

public class YuushyaItemFactory {
    public static AbstractYuushyaItem create(YuushyaRegistryData.Item item) {
        return switch (item.classType) {
            case "HatItem" -> new HatItem(YuushyaItemFactory.getItemProperties(item), item.properties.lines);
            case "StructureCreatorItem" -> new StructureCreatorItem(YuushyaItemFactory.getItemProperties(item), item.properties.lines, item.usage.createNbt, item.usage.cancelNbt);
            case "BlueprintItem" -> new BlueprintItem(YuushyaItemFactory.getItemProperties(item), item.properties.lines);
            default -> new AbstractYuushyaItem(YuushyaItemFactory.getItemProperties(item), item.properties.lines);
        };
    }

    public static Item.Properties getItemProperties(YuushyaRegistryData.Item item) {
        Item.Properties properties = new Item.Properties().arch$tab(YuushyaCreativeModeTab.toGroup(item.itemGroup)).m_41487_(item.properties.maxCount);
        if (item.properties.rarity != null && !item.properties.rarity.isEmpty()) {
            properties = properties.m_41497_(YuushyaUtils.toRarity(item.properties.rarity));
        }
        if (item.properties.maxDamage != 0) {
            properties = properties.m_41503_(item.properties.maxDamage);
        }
        if (item.properties.fireProof) {
            properties = properties.m_41486_();
        }
        return properties;
    }
}

