/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.utils;

import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class YuushyaModelUtils {
    public static final Splitter COMMA_SPLITTER = Splitter.on((char)',');
    public static final Splitter EQUAL_SPLITTER = Splitter.on((char)'=').limit(2);
    public static final Map<String, Predicate<BlockState>> PREDICATE_MAP = new HashMap<String, Predicate<BlockState>>();

    public static List<BlockState> getBlockStateFromVariantString(Block block, String variantKey) {
        return block.m_49965_().m_61056_().stream().filter(YuushyaModelUtils.predicate(block, variantKey)).toList();
    }

    public static boolean isBlockStateInVariantString(BlockState blockState, String variantKey) {
        return YuushyaModelUtils.predicate(blockState.m_60734_(), variantKey).test(blockState);
    }

    public static Predicate<BlockState> predicate(Block block, String variantKey) {
        String s = String.valueOf(BuiltInRegistries.f_256975_.m_7981_((Object)block)) + "#" + variantKey;
        return PREDICATE_MAP.computeIfAbsent(s, s1 -> YuushyaModelUtils.predicateBuilder((StateDefinition<Block, BlockState>)block.m_49965_(), variantKey));
    }

    public static Predicate<BlockState> predicateBuilder(StateDefinition<Block, BlockState> stateDefinition, String string) {
        if (string.equals("empty")) {
            return blockState -> blockState != null && blockState.m_60713_((Block)stateDefinition.m_61091_());
        }
        HashMap map = Maps.newHashMap();
        for (String s : COMMA_SPLITTER.split((CharSequence)string)) {
            Iterator iterator = EQUAL_SPLITTER.split((CharSequence)s).iterator();
            if (!iterator.hasNext()) continue;
            String key = (String)iterator.next();
            Property property = stateDefinition.m_61081_(key);
            if (property != null && iterator.hasNext()) {
                String value = (String)iterator.next();
                Object comparable = YuushyaModelUtils.getValueHelper(property, value);
                if (comparable == null) {
                    throw new RuntimeException("Unknown value: '" + value + "' for blockstate property: '" + key + "' " + String.valueOf(property.m_6908_()));
                }
                map.put(property, comparable);
                continue;
            }
            if (key.isEmpty()) continue;
            throw new RuntimeException("Unknown blockstate property: '" + key + "'");
        }
        Block block = (Block)stateDefinition.m_61091_();
        return blockState -> {
            if (blockState != null && blockState.m_60713_(block)) {
                for (Map.Entry entry : map.entrySet()) {
                    if (Objects.equals(blockState.m_61143_((Property)entry.getKey()), entry.getValue())) continue;
                    return false;
                }
                return true;
            }
            return false;
        };
    }

    @Nullable
    private static <T extends Comparable<T>> T getValueHelper(Property<T> property, String name) {
        return (T)((Comparable)property.m_6215_(name).orElse(null));
    }
}

