/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.utils;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.yuushya.block.blockstate.YuushyaBlockStates;
import com.yuushya.registries.YuushyaRegistryData;
import java.awt.Color;
import java.util.Arrays;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;

public class YuushyaUtils {
    public static int vertexSize() {
        return DefaultVertexFormat.f_85811_.m_86020_() / 4;
    }

    public static MapColor toBlockMaterial(String material) {
        return switch (material) {
            case "air", "structure_void", "portal", "miscellaneous", "redstone_lamp", "glass", "barrier", "cake" -> MapColor.f_283808_;
            case "carpet", "web", "wool" -> MapColor.f_283930_;
            case "plants", "tall_plants", "nether_plants", "leaves", "cactus", "coral", "gourd", "dragon_egg" -> MapColor.f_283915_;
            case "underwater_plant", "sea_grass", "water", "bubble_column" -> MapColor.f_283864_;
            case "lava", "fire", "tnt" -> MapColor.f_283816_;
            case "snow_layer", "snow_block", "powder_snow" -> MapColor.f_283811_;
            case "sculk" -> MapColor.f_283927_;
            case "clay" -> MapColor.f_283744_;
            case "soil" -> MapColor.f_283762_;
            case "solid_organic" -> MapColor.f_283824_;
            case "packed_ice", "ice" -> MapColor.f_283828_;
            case "sand" -> MapColor.f_283761_;
            case "sponge" -> MapColor.f_283832_;
            case "shulker", "amethyst" -> MapColor.f_283889_;
            case "wood", "nether_wood", "bamboo_sapling", "bamboo" -> MapColor.f_283825_;
            case "stone", "piston" -> MapColor.f_283947_;
            default -> MapColor.f_283906_;
        };
    }

    public static SoundType toSound(String sound) {
        return switch (sound) {
            case "wood" -> SoundType.f_56736_;
            case "gravel" -> SoundType.f_56739_;
            case "plant" -> SoundType.f_56740_;
            case "lily_pads" -> SoundType.f_56741_;
            case "stone" -> SoundType.f_56742_;
            case "metal" -> SoundType.f_56743_;
            case "glass" -> SoundType.f_56744_;
            case "wool" -> SoundType.f_56745_;
            case "sand" -> SoundType.f_56746_;
            case "snow" -> SoundType.f_56747_;
            case "ladder" -> SoundType.f_56748_;
            case "anvil" -> SoundType.f_56749_;
            case "slime" -> SoundType.f_56750_;
            case "honey" -> SoundType.f_56751_;
            case "wet_grass" -> SoundType.f_56752_;
            case "coral" -> SoundType.f_56753_;
            case "bamboo" -> SoundType.f_56754_;
            case "bamboo_sapling" -> SoundType.f_56755_;
            case "scaffolding" -> SoundType.f_56756_;
            case "sweet_berry_bush" -> SoundType.f_56757_;
            case "crop" -> SoundType.f_56758_;
            case "stem" -> SoundType.f_56759_;
            case "vine" -> SoundType.f_56760_;
            case "nether_wart" -> SoundType.f_56761_;
            case "lantern" -> SoundType.f_56762_;
            case "nether_stem" -> SoundType.f_56763_;
            case "nylium" -> SoundType.f_56710_;
            case "fungus" -> SoundType.f_56711_;
            case "root" -> SoundType.f_56712_;
            case "shroomlight" -> SoundType.f_56713_;
            case "nether_vine" -> SoundType.f_56714_;
            case "nether_vine_lower_pitch" -> SoundType.f_56715_;
            case "soul_sand" -> SoundType.f_56716_;
            case "soul_soil" -> SoundType.f_56717_;
            case "basalt" -> SoundType.f_56718_;
            case "wart" -> SoundType.f_56719_;
            case "netherrack" -> SoundType.f_56720_;
            case "nether_brick" -> SoundType.f_56721_;
            case "nether_sprout" -> SoundType.f_56722_;
            case "nether_ore" -> SoundType.f_56723_;
            case "bone" -> SoundType.f_56724_;
            case "netherite" -> SoundType.f_56725_;
            case "ancient_debris" -> SoundType.f_56726_;
            case "lodestone" -> SoundType.f_56727_;
            case "chain" -> SoundType.f_56728_;
            case "nether_gold" -> SoundType.f_56729_;
            case "gilded_blackstone" -> SoundType.f_56730_;
            case "candle" -> SoundType.f_154653_;
            case "amethyst" -> SoundType.f_154654_;
            case "amethyst_cluster" -> SoundType.f_154655_;
            case "small_amethyst_bud" -> SoundType.f_154656_;
            case "medium_amethyst_bud" -> SoundType.f_154657_;
            case "large_amethyst_bud" -> SoundType.f_154658_;
            case "tuff" -> SoundType.f_154659_;
            case "calcite" -> SoundType.f_154660_;
            case "dripstone_block" -> SoundType.f_154661_;
            case "pointed_dripstone" -> SoundType.f_154662_;
            case "copper" -> SoundType.f_154663_;
            case "cave_vines" -> SoundType.f_154664_;
            case "spore_blossom" -> SoundType.f_154665_;
            case "azalea" -> SoundType.f_154666_;
            case "flowering_azalea" -> SoundType.f_154667_;
            case "moss_carpet" -> SoundType.f_154668_;
            case "moss" -> SoundType.f_154669_;
            case "big_dripleaf" -> SoundType.f_154670_;
            case "small_dripleaf" -> SoundType.f_154671_;
            case "rooted_dirt" -> SoundType.f_154672_;
            case "hanging_roots" -> SoundType.f_154673_;
            case "azalea_leaves" -> SoundType.f_154674_;
            case "sculk_sensor" -> SoundType.f_154675_;
            case "glow_lichen" -> SoundType.f_154676_;
            case "deepslate" -> SoundType.f_154677_;
            case "deepslate_bricks" -> SoundType.f_154678_;
            case "deepslate_tiles" -> SoundType.f_154679_;
            case "polished_deepslate" -> SoundType.f_154680_;
            default -> SoundType.f_56743_;
        };
    }

    public static IntegerProperty getFormFromState(BlockState blockState) {
        if (blockState.m_61138_((Property)YuushyaBlockStates.FORM2)) {
            return YuushyaBlockStates.FORM2;
        }
        if (blockState.m_61138_((Property)YuushyaBlockStates.FORM3)) {
            return YuushyaBlockStates.FORM3;
        }
        if (blockState.m_61138_((Property)YuushyaBlockStates.FORM4)) {
            return YuushyaBlockStates.FORM4;
        }
        if (blockState.m_61138_((Property)YuushyaBlockStates.FORM5)) {
            return YuushyaBlockStates.FORM5;
        }
        if (blockState.m_61138_((Property)YuushyaBlockStates.FORM6)) {
            return YuushyaBlockStates.FORM6;
        }
        if (blockState.m_61138_((Property)YuushyaBlockStates.FORM7)) {
            return YuushyaBlockStates.FORM7;
        }
        if (blockState.m_61138_((Property)YuushyaBlockStates.FORM8)) {
            return YuushyaBlockStates.FORM8;
        }
        return null;
    }

    public static Rarity toRarity(String rarity) {
        return switch (rarity) {
            case "common" -> Rarity.COMMON;
            case "uncommon" -> Rarity.UNCOMMON;
            case "rare" -> Rarity.RARE;
            case "epic" -> Rarity.EPIC;
            default -> Rarity.COMMON;
        };
    }

    public static RenderType toRenderType(String renderType) {
        return switch (renderType) {
            case "cutout" -> RenderType.m_110463_();
            case "cutoutmipped" -> RenderType.m_110457_();
            case "translucent" -> RenderType.m_110466_();
            case "solid" -> RenderType.m_110451_();
            default -> RenderType.m_110463_();
        };
    }

    public static BlockColor toBlockColor(String type, String value) {
        return switch (type) {
            case "null" -> (blockState, blockAndTintGetter, blockPos, i) -> 0;
            case "singlecolor" -> (state, world, pos, tintIndex) -> Color.getColor(value).getRGB();
            case "vanilla" -> {
                switch (value) {
                    case "tall_plant": {
                        yield (blockState, blockAndTintGetter, blockPos, i) -> blockAndTintGetter == null || blockPos == null ? -1 : BiomeColors.m_108793_((BlockAndTintGetter)blockAndTintGetter, (BlockPos)(blockState.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.UPPER ? blockPos.m_7495_() : blockPos));
                    }
                    case "grass": {
                        yield (blockState, blockAndTintGetter, blockPos, i) -> blockAndTintGetter == null || blockPos == null ? GrassColor.m_46415_((double)0.5, (double)1.0) : BiomeColors.m_108793_((BlockAndTintGetter)blockAndTintGetter, (BlockPos)blockPos);
                    }
                    case "spruce": {
                        yield (blockState, blockAndTintGetter, blockPos, i) -> FoliageColor.m_46106_();
                    }
                    case "birch": {
                        yield (blockState, blockAndTintGetter, blockPos, i) -> FoliageColor.m_46112_();
                    }
                    case "leaves": {
                        yield (blockState, blockAndTintGetter, blockPos, i) -> blockAndTintGetter == null || blockPos == null ? FoliageColor.m_46113_() : BiomeColors.m_108804_((BlockAndTintGetter)blockAndTintGetter, (BlockPos)blockPos);
                    }
                    case "water": {
                        yield (blockState, blockAndTintGetter, blockPos, i) -> blockAndTintGetter == null || blockPos == null ? -1 : BiomeColors.m_108811_((BlockAndTintGetter)blockAndTintGetter, (BlockPos)blockPos);
                    }
                    case "redstone": {
                        yield (blockState, blockAndTintGetter, blockPos, i) -> RedStoneWireBlock.m_55606_((int)((Integer)blockState.m_61143_((Property)RedStoneWireBlock.f_55500_)));
                    }
                    case "sugar_cane": {
                        yield (blockState, blockAndTintGetter, blockPos, i) -> blockAndTintGetter == null || blockPos == null ? -1 : BiomeColors.m_108793_((BlockAndTintGetter)blockAndTintGetter, (BlockPos)blockPos);
                    }
                    case "attached_stem": {
                        yield (blockState, blockAndTintGetter, blockPos, i) -> 14731036;
                    }
                    case "stem_with_age": {
                        yield (blockState, blockAndTintGetter, blockPos, i) -> {
                            int j = (Integer)blockState.m_61143_((Property)StemBlock.f_57013_);
                            int k = j * 32;
                            int l = 255 - j * 8;
                            int m = j * 4;
                            return k << 16 | l << 8 | m;
                        };
                    }
                    case "lily_pad": {
                        yield (blockState, blockAndTintGetter, blockPos, i) -> blockAndTintGetter == null || blockPos == null ? 7455580 : 2129968;
                    }
                }
                yield (blockState, blockAndTintGetter, blockPos, i) -> 0;
            }
            default -> (blockState, blockAndTintGetter, blockPos, i) -> 0;
        };
    }

    public static BlockBehaviour.OffsetType toOffsetType(String offset) {
        if (offset == null) {
            return BlockBehaviour.OffsetType.NONE;
        }
        return switch (offset) {
            case "xz" -> BlockBehaviour.OffsetType.XZ;
            case "xyz" -> BlockBehaviour.OffsetType.XYZ;
            default -> BlockBehaviour.OffsetType.NONE;
        };
    }

    public static BlockState getBlockState(BlockState blockState, LevelAccessor world, BlockPos blockPos) {
        return blockState;
    }

    public static <T> ListTag toListTag(T ... values) {
        ListTag listTag = new ListTag();
        Arrays.stream(values).toList().forEach(e -> {
            if (e instanceof Float) {
                Float e1 = (Float)e;
                listTag.add((Object)FloatTag.m_128566_((float)e1.floatValue()));
            } else if (e instanceof Double) {
                Double e1 = (Double)e;
                listTag.add((Object)DoubleTag.m_128500_((double)e1));
            }
        });
        return listTag;
    }

    public static BlockSetType toBlockSetType(YuushyaRegistryData.Block.Properties properties) {
        if (properties != null) {
            if ("wood".equals(properties.material)) {
                return BlockSetType.f_271198_;
            }
            return BlockSetType.f_271132_;
        }
        return BlockSetType.f_271401_;
    }
}

